/*
Trucs sur les nombres

Voici un certain nombre de procdures et de fonctions sur les
nombres que j'ai dcouvertes ou mises au point pour raliser mes
programmes pdagogiques.

Certaines ne sont pas trop optimises ou pourraient tre ralises
plus simplement avec les nouvelles fonctions de Delphi dont certaines
sont voques au bas de cette page.

Mais comme la vitesse n'est pas un facteur essentiel dans ce genre
de logiciels....

Je les utilise depuis de nombreuses annes dj (depuis Turbo-Pascal)
et il me semble qu'elles fonctionnent correctement.

Je vous les fournis telles-quelles, sans aucune garantie
et bien sr je dgage toute responsabilit quant  l'usage
que vous pourriez en faire, etc, etc...

En esprant cependant qu'elles pourront vous rendre service.

Si vous le souhaitez, contactez moi.

j-c.meier@ac-nancy-metz.fr

Site PedagoJiC : http://jc.meier.free.fr

*/

// Pour crire  en tranche de 3 chiffres la partie entire d'un nombre rl
FUNCTION Tranche_Entier ( La_Chaine : STRING) : STRING;
VAR fin   : BYTE;
    ch    : STRING;
    nfois : BYTE;
BEGIN
  ch :='';
  nfois := 0;
    fin := Length(La_Chaine);
    While fin > 3 DO
    BEGIN
      ch:= ' '+copy(La_Chaine,fin-2,3)+Ch;
      dec(fin,3);
      inc(nfois);
    END;
    ch := Copy(La_Chaine,1,length(La_Chaine)-nfois*3)+ch;

  IF Length(La_Chaine) <= 3 THEN
  Tranche_Entier := La_Chaine
  ELSE
  Tranche_Entier := ch;
END;


// Pour crire en tranches de 3 chiffres la partie dcimale d'un nombre rel
FUNCTION Tranche_Decimal ( La_Chaine : STRING) : STRING;
VAR debut : BYTE;
    ch    : STRING;
    nfois : BYTE;
BEGIN
  ch :='';
  nfois := 0;
  debut := 1;
  While debut <= length(La_Chaine) - 3 DO
  BEGIN
    ch:= ch+copy(La_Chaine,debut,3)+' ';
    inc(debut,3);
    inc(nfois);
  END;
  ch := ch+Copy(La_Chaine,nfois*3+1,length(La_Chaine)-nfois*3);

  IF Length(La_Chaine) <= 3 THEN
  Tranche_Decimal := La_Chaine
  ELSE
  Tranche_Decimal := ch;
END;

// Ecrit les nombres rels (convertis en chanes) correctement, en sparant les tranches de
//   3 chiffres   ex : 1247.4563 --> 1 247.456 3
FUNCTION Tranche( Ma_Chaine : STRING) : STRING;

VAR
    Chaine_Gauche, Chaine_Droite : STRING;
     Posi    : BYTE;
     Long    : BYTE;
BEGIN
  Chaine_Droite := '';
  Chaine_Gauche := '';
  IF Pos('.',Ma_Chaine) = 0 THEN
  Tranche := Tranche_Entier(Ma_Chaine)
  ELSE
  BEGIN
    Long := Length(Ma_Chaine);
    Posi := POS('.',Ma_Chaine);
    Chaine_Gauche  := Copy(Ma_Chaine,1,posi-1);
    Chaine_Droite  := Copy(Ma_Chaine,Posi+1,long-posi);
    Chaine_Gauche  := Tranche_Entier(Chaine_Gauche);
    Chaine_Droite  := Tranche_Decimal(Chaine_Droite);
    Tranche := Chaine_Gauche+'.'+Chaine_Droite;
  END;
END;

// aprs avoir "tranch" un nombre il faut parfois le "recompacter"
function Enleve_Espace (chaine : string) : String;
Var i : integer;
begin
  For i := 1 to length(chaine) do
  if Copy(chaine,i,1) = ' ' then delete(chaine,i,1);
  result := chaine;
end;

// pour savoir si un nombre est premier
function est_premier(nb : integer) : boolean;
var i : integer;
begin
  result := true;
  for i := 2 to nb-1 do
  if nb mod i = 0 then
  begin
    result := false;
    exit;
  end;
end;

// ex    1234.   ---> 1234
Function Enleve_Point(Chaine : String) : String;
begin
  If Copy(chaine,length(chaine),1) = '.' then
  Delete(Chaine,length(chaine),1);
  result := chaine;
end;
// ex : 234,45 ---> 234.45
Function Remplace_Virgule(chaine :string):string;
Var i : byte;
begin
  for i := 1 to length(chaine) do
  If Copy(chaine,i,1) = ',' then
  begin
    Delete(Chaine,i,1);
    Insert('.',Chaine,i);
  end;
  result := chaine;
end;

// ex : 123.400 ---> 123.4
Function Enleve_Zero_Dte(Chaine : String): String;
begin
  if pos('.',chaine) > 0 then
  While Copy(Chaine,length(chaine),1) = '0' do
  Delete(Chaine,length(chaine),1);
  Result := chaine;
end;

// ex : 1234,00   -->   1234.00 --> 1234. --> 1234
Function Correct(Chaine : String) : string;
Var ch : String;
begin
  ch := Remplace_virgule(chaine);
  ch := Enleve_zero_dte(chaine);
  ch := Enleve_Point(ch);
  result := ch;
end;

// pour savoir par ex si le nombre 234 est divisible par 4
// if est_divisible(4,234) then
function est_divisible_par( divi, le_nb : integer) : boolean;
begin
  result := (le_nb mod divi = 0);
end;

// Calcule le maximum de 3 nombres
// pour 2 nombre prendre n1,n2,n2
function Max3(nb1,nb2,nb3  : Word) : Word;
Var tempo : word;
begin
  tempo := 0;
  if nb1 > tempo then tempo := nb1;
  if nb2 > tempo then tempo := nb2;
  if nb3 > tempo then tempo := nb3;
  result := tempo;
end;

// Calcule le minimun de 3 nombres
// pour 2 nombre prendre n1,n2,n2
function Min3(nb1,nb2,nb3  : Word) : Word;
Var tempo : word;
begin
  tempo := 65535;
  if nb1 < tempo then tempo := nb1;
  if nb2 < tempo then tempo := nb2;
  if nb3 < tempo then tempo := nb3;
  result := tempo;
end;

//  Plus Grand Diviseur Commun de 3 nombres
// pour 2 nombre prendre n1,n2,n2
function PGDC(nb1,nb2,nb3  : Word) : Word;
var i : word;
begin
  result := 1;
  for i := 1 to max3(nb1,nb2,nb3) do
  if ((nb1 mod i = 0) and (nb2 mod i = 0) and (nb3 mod i = 0))
  then result := i;
end;

// Plus Petit Multiple Commun de 3 nombres
// pour 2 nombre prendre n1,n2,n2
function PPMC(nb1,nb2,nb3  : Word) : Word;
var i : word;
begin
  result := 65535;
  for i := Min3(nb1,nb2,nb3) to 65535  do
  if ((i mod nb1 = 0) and (i mod nb2 = 0) and (i mod nb3 = 0))
  then
  begin
    result := i;
    exit;
  end;
end;

// Puissance entire d'un nombre entier
Function Puissance(nb : INTEGER; exp : Integer): Integer;
VAR i : integer;
    n : integer;

BEGIN
  IF exp = 0 THEN result := 1
  ELSE
  BEGIN
    n := 1;
    FOR i := 1 TO exp  DO
    n := n * nb;
    result := n;
  END;
END;

// Puissance entire d'un nombre entier plus grand
Function L_Puissance(nb : longint; exp : longint): longint;
VAR i : longint;
    n : LongInt;

BEGIN
  IF exp = 0 THEN result := 1
  ELSE
  BEGIN
    n := 1;
    FOR i := 1 TO exp  DO
    n := n * nb;
    result := n;
  END;
END;

// Puissance relle d'un rel
function Power(x, y : extended) : extended;
 begin
   result := exp(y*ln(x));
 end;

 // fonction tangente
// Delphi ne connat que Sin, Cos, ArcTan
function Tan(X: Real): Real;
begin
  result := Sin(x) / Cos(x)
end;

function ArcSin(X: Real): Real;
begin
  result :=  ArcTan (x/sqrt (1-sqr (x)))
end;

function ArcCos(X: Real): Real;
begin
  result :=  ArcTan (sqrt (1-sqr (x)) /x);
end;

// Transforme un rel en chane sans utiliser de variable intermdiaire
// Ce qui peut tre ralis avec Format cf ci-dessous
function RealToStr(nb : real) : string;
var ch : string;
begin
  str(nb:0:2,ch);  // avec 2 dcimales ici
  result := ch;
end;

// donne  la valeur relle d'une chaine sans utiliser de variable intermdiaire
function ValReal(ch : string) : real;
Var code : integer;
    nb : real;
begin
  Val(ch, nb, code);
  if code = 0 then
  result := nb
  else ShowMessage('Erreur dans la chane !');
end;


 // la fonction  Round arrondit selon le systme bancaire
 //  milieu ---> nb pair
 //   0,5 ---> 0   1,5 ---> 2    2,5 ---> 2
 //   RoundUp arrondit  toujour au dessus pour 0,5 et plus
 //    0,5 ---> 1   1,5 ---> 2    2,5 ---> 3
function RoundUp(X: Extended): Extended;
 begin
   Result := Trunc(X) + Trunc (Frac(X) * 2);
 end;

// distance de 2 points dans un repre orthonormal
function distance(x1,y1,x2,y2 : real) : Real;
begin
  distance :=  sqrt(sqr(x2-x1)+sqr(y2-y1));
end;

// et comme la fonction logarithme dcimal n'existe pas dans la version standard
function Log (x: real) : real;
begin
  result := Ln(x)/Ln(10);
end;


// et un dernier petit dernier truc
//Pour avoir une srie de nombres compris entre 0 et 999 tous diffrents
// voici une solution avec avec un tableau de boolens pr initialiss :

Var
deja_pris : array[1..1000] of boolean;

procedure TForm1.FormActivate(Sender: TObject);
Var i : integer;
begin
   For i := 1 to 1000
   do deja_pris[i] := false;  // aucun des 1000 nombres n'a encore t utilis
end;

procedure TForm1.Button1Click(Sender: TObject);
Var
    nb : integer;
begin
   randomize;
   repeat
     nb := random(1000);
   until not deja_pris[nb];  // attention  ne prendre que 1000 valeurs au maximum
   deja_pris[nb] := true;
//   pour tester : caption := inttostr(nb);
end;



// Utilisation des fonctions de formatage spcifiques de Delphi
// cf chanes de format dans l'aide

// ex   342 --> 000342
function Format6c(nb : longint): string; // 6 chiffres ici
var s: string;
begin
  FmtStr(s, '%.6d', [nb]);
  result := s;
end;

// Spare en Tranches de 3 chiffres un entier
function Format_Tranche(nb : longint) : string;
begin
  result := FormatFloat('#,', nb);
end;


// Voir aussi dans l'aide la trs intressante fonction Format

//  var nb : extended;
//  ch : string;

// nb := 41.47*12.56;
// ch := format('%f',[nb]);   dcimal  2 chiffres par dfaut
// ch := format('nb = %.6f',[nb]);   dcimal  6 chiffres
// ch := format('la rponse est = %d',[round(nb)]);  arrondi  l'entier

