unit WinPanel;
  // Panel dplaable simulant une fentre
  // Plus facile et plus souple  utiliser qu'une fentre MDI,
  // pour sa cration, le passage des variables, le drag and drop.
  // Peut servir  crer une barre d'outils, une aide, etc ...
  // 7/3/97 je remets BorderStyle
  // 28/05/02 utilisation de la fonte Marlett pour amliorer le x
  // de fermeture
  //
  // freeware  Jean Claude Meier 1996/2002
  // Tlchargement Site PedagoJiC : http://jc.meier.free.fr

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Menus, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TWinPanel = class(TCustomPanel)
  private
    { Dclarations private }
    FButton : TButton;
    FShape  : TShape;
    FTitre  : String;
    FCoulTitre : TColor;
    FCoulFondTitre : TColor;
    FPosTitre : TAlignment;
    FLabel  : TLabel;
    FBordure : TBevelWidth;

    procedure Cache_Panel(Sender : TObject);
    procedure Deplace_Panel(Sender : TObject;Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
    procedure Redimensionne;
  protected
    { Dclarations protected }
    procedure WMsize(var message : twmsize); message wm_size;
  public
    { Dclarations public }
    procedure SetCoulTitre(Coul : TColor);
    procedure SetCoulFondTitre(Coul : TColor);
    procedure SetPosTitre(pos : TAlignment);
    procedure SetFTitre(Str : String);
    procedure SetBordure(bord : TBevelWidth);
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Dclarations published }
    property Titre : String read FTitre write SetFTitre;
    property CoulTitre : TColor read FCoulTitre write SetCoulTitre
    default clNavy;
    property CoulFondTitre : TColor read FCoulFondTitre write SetCoulFondTitre
    default clWhite;
    property PosTitre : TAlignment read FPosTitre write SetPosTitre;
    property Bordure : TBevelWidth read FBordure write SetBordure
    default 1;

   // Proprits

  //  pas compatible avec dplaable
  //  property Align;
    property Alignment;
    property Ctl3D;
    property ParentColor;
   // pas compatible avec style fentre
   // property BevelInner;
    property Cursor;
    property ParentCtl3D;
    property BevelOuter;
    property DragCursor;
    property ParentFont;
    //property BevelWidth;
    property DragMode;
    property ParentShowHint;
    property BorderStyle;
    property Enabled;
    property PopupMenu;
   // pas compatible avec style fentre
   // property BorderWidth;
    property Font;
    property ShowHint;
    property Height;
    property Caption;
    property HelpContext;
    property TabOrder;
    property Color;
    property Hint;
    property TabStop;
    property Left;
    property Tag;
    property Locked;
    property Top;
    property Name;
    property Visible;
    property Width;

  // Evnements
    property OnClick;
    property OnDragOver;
    property OnMouseMove;
    property OnDblClick;
    property OnEndDrag;
    property OnMouseUp;
    property OnDragDrop;
    property OnMouseDown;
    property OnResize;
    property OnEnter;
    property OnExit;

  end;

procedure Register;

implementation

procedure TWinPanel.SetFTitre(Str : String);
Begin
  Ftitre := Str;
  FLabel.Caption := FTitre;
End;

procedure TWinPanel.SetCoulFondTitre(Coul : TColor);
begin
  if FCoulFondTitre <> Coul then
  begin
    FCoulFondTitre := Coul;
    FLabel.Color := FCoulFondTitre;
    FShape.Brush.Color := FCoulFondTitre;
    FShape.Pen.Color := FCoulFondTitre;
  end;
end;

procedure TWinPanel.SetCoulTitre(Coul : TColor);
begin
  if FCoulTitre <> Coul then
  begin
    FCoulTitre := Coul;
    FLabel.Font.Color := FCoulTitre;
  end;
end;

procedure TWinPanel.SetPosTitre(Pos : TAlignment);
begin
  if FPosTitre <> Pos then
  begin
    FPosTitre := Pos;
    FLabel.Alignment := FPosTitre;
  end;
end;

procedure TWinPanel.SetBordure(Bord : TBevelWidth);
begin
  if FBordure <> Bord then
  begin
    FBordure := Bord;
    BevelWidth := FBordure;
    Redimensionne;
  end;
end;

procedure TWinPanel.Cache_Panel(Sender : TObject);
begin
  Visible := False;
end;

procedure TWinPanel.ReDimensionne;
begin
  if BorderStyle = bsSingle then
  begin
    FShape.SetBounds(BevelWidth,BevelWidth,Width-2*BevelWidth-4,14);
    FButton.Left := Width-5-FButton.Width-BevelWidth;
  end
  else
  begin
    FShape.SetBounds(BevelWidth,BevelWidth,width-2*BevelWidth,14);
    FButton.Left := Width-1-FButton.Width-BevelWidth;
  end;
  FButton.Top := BevelWidth+2;
  FLabel.Left := BevelWidth+2;
  FLabel.Top :=  BevelWidth;
  FLabel.Width := Width-18 - BevelWidth*2;
end;

procedure TWinPanel.WMsize(var message : twmsize);
begin
  Redimensionne;
end;

procedure TWinPanel.Deplace_Panel(Sender : TObject;Button: TMouseButton;
Shift: TShiftState; X, Y: Integer);
const
  SC_DragMove = $F012;
begin
  if (Button = mbLeft) then
  begin
    ReleaseCapture;
    PostMessage(Self.Handle,WM_SysCommand, SC_DragMove, 0);
  end;
end;

constructor TWinPanel.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  Width := 120;
  Height := 80;
  FShape := TShape.Create(Self);
  FShape.SetBounds(BevelWidth,BevelWidth,Width-2*BevelWidth,14);
  FShape.Brush.Color := clNavy;
  FShape.Pen.Color := clNavy;
  FShape.Parent := Self;
  FShape.OnMouseDown := Deplace_Panel;

  FButton := TButton.Create(Self);
  FButton.SetBounds(Width-14-BevelWidth,2+BevelWidth,12,11);
  FButton.Font.Name := 'Marlett';
  FButton.Font.Size := 6;
  
  FButton.Caption := 'r';  // x de fermeture
  FButton.Parent := Self;
  FButton.OnClick := Cache_Panel;

  FLabel := TLabel.Create(Self);
  FLabel.Left := BevelWidth+2;
  FLabel.Top := BevelWidth;
  FLabel.Width := Width-18 - BevelWidth*2;
  FLabel.Height := 14;
  FLabel.Autosize := False;
  FLabel.Font.Color := clWhite;
  FLabel.Color := clNavy;
  FLabel.Font.Name := 'Courier New';
  FLabel.Font.Size := 8;
  FLabel.Parent := Self;
  FLabel.OnMouseDown := Deplace_Panel;

  FCoulFondTitre := clNavy;
  FCoulTitre := clWhite;
  FBordure := 1;
end;

destructor TWinPanel.Destroy;
begin
  FShape.Destroy;
  FButton.Destroy;
  FLabel.Destroy;
  inherited Destroy;
end;

procedure Register;
begin
  RegisterComponents('Exemples', [TWinPanel]);
end;

end.
