unit U_wptest;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, WinPanel, ColorGrd, StdCtrls, Grids, Calendar,
  Buttons, Spin, ShellAPI;

type
  TWPTForm = class(TForm)
    WinPanel1: TWinPanel;
    ColorGrid1: TColorGrid;
    WinPanel2: TWinPanel;
    Memo1: TMemo;
    WinPanel3: TWinPanel;
    Calendar1: TCalendar;
    WinPanel4: TWinPanel;
    Image1: TImage;
    BitBtn1: TBitBtn;
    Timer1: TTimer;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    WinPanel5: TWinPanel;
    ListBox1: TListBox;
    SpinButton1: TSpinButton;
    SpinButton2: TSpinButton;
    Label2: TLabel;
    Label3: TLabel;
    WinPanel6: TWinPanel;
    Label1: TLabel;
    WinPanel7: TWinPanel;
    BBCommande: TBitBtn;
    procedure ColorGrid1Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure SpinButton2DownClick(Sender: TObject);
    procedure SpinButton2UpClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Calendar1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BBCommandeClick(Sender: TObject);
  private
    { Dclarations private }
  public
    { Dclarations public }
  end;

var
  WPTForm: TWPTForm;

implementation

{$R *.DFM}

Const Mois :  ARRAY[1..12] of String = ('Janvier','Fvrier','Mars','Avril',
                                        'Mai','Juin','Juillet','Aot','Septembre',
                                        'Octobre','Novembre','Dcembre');

procedure TWPTForm.ColorGrid1Change(Sender: TObject);
begin
    color := Colorgrid1.foregroundcolor;
    memo1.Font.color := Colorgrid1.backgroundColor;
    WinPanel4.CoulfondTitre := Colorgrid1.backgroundColor;
end;

procedure TWPTForm.Timer1Timer(Sender: TObject);
begin
  Button1.enabled := not WinPanel1.visible;
  Button2.enabled := not WinPanel2.visible;
  Button3.enabled := not WinPanel3.visible;
  Button4.enabled := not WinPanel5.visible;
end;

procedure TWPTForm.Button1Click(Sender: TObject);
begin
  WinPanel1.visible := true;
  winpanel1.bringtofront;
end;

procedure TWPTForm.Button2Click(Sender: TObject);
begin
  WinPanel2.visible := true;
  winpanel2.bringtofront;
end;

procedure TWPTForm.Button3Click(Sender: TObject);
begin
  WinPanel3.visible := true;
  winpanel3.bringtofront;
end;

procedure TWPTForm.Button4Click(Sender: TObject);
begin
  WinPanel5.visible := true;
  winpanel5.bringtofront;
end;

procedure TWPTForm.SpinButton1UpClick(Sender: TObject);
begin
  Calendar1.year := Calendar1.Year +1;
  label2.Caption :=  inttostr(calendar1.Year);
end;

procedure TWPTForm.SpinButton1DownClick(Sender: TObject);
begin
  Calendar1.year := Calendar1.Year -1;
  label2.Caption := inttostr(calendar1.Year);
end;

procedure TWPTForm.SpinButton2UpClick(Sender: TObject);
begin
  If calendar1.Month < 12 then
  Calendar1.month := Calendar1.Month +1;
  label3.Caption :=  mois[calendar1.month];
end;

procedure TWPTForm.SpinButton2DownClick(Sender: TObject);
begin
  If calendar1.Month > 1  then
  Calendar1.month := Calendar1.Month -1;
  label3.Caption :=  mois[calendar1.month];
end;


procedure TWPTForm.FormActivate(Sender: TObject);
begin
  label2.Caption := inttostr(calendar1.Year);
  label3.Caption :=  mois[calendar1.month];
end;

procedure TWPTForm.Calendar1Change(Sender: TObject);
begin
  Memo1.Lines[0] := Inttostr(Calendar1.day)+'/'+
  inttostr(calendar1.month)+'/'+inttostr(calendar1.Year);
end;

procedure TWPTForm.FormCreate(Sender: TObject);
begin
  ClientWidth := Button4.left+Button4.Width+4;
  ClientHeight := WinPanel4.Top+WinPanel4.Height+4;
end;

procedure TWPTForm.BBCommandeClick(Sender: TObject);
begin
  if  ShellExecute(handle,'open','commande.htm','','',SW_SHOW)<= 32
  then MessageDlg('Impossible de charger le bon de commande !',mtError,[mbOk],0);
end;

end.
