unit FonTImag;
 // v 1.15  Jean Claude Meier , freeware.
 // cf fichier Lisez.moi.txt et programme exemple Test_FI.dpr
 //  Dernire M.A.J 1/11/2000
 //  Site PedagoJiC : http://jc.meier.free.fr
interface

uses
  Classes, Graphics, Forms, Dialogs, ExtCtrls, StdCtrls ;

type
  (* Type of frame around the FontImage *)
  // Type de cadre autour de la FontImage
  TCadreType = (caNone,caStandard,ca3DRaised,ca3DLowered);

  (* Our new component   *)
  // notre nouveau composant
  TFontImage = class(TImage)
  private
    FTitre     : String;     (* Text, texte du titre *)
    FFont      : TFont;      (* Font to choose , criture *)
    FCoulFond  : TColor;     (* Color around the text , couleur autour du texte *)
    FCadre     : TCadreType; (* Frame around FontImage, cadre  *)
    FDecalHor  : integer;    (* Horizontal position from (0,0) , dcalage horizontal *)
    FDecalVert : integer;    (* Vertical position from (0,0) , dcalage vertical *)
    procedure ReDessine(Sender: TObject);
    procedure SetFont(Value : TFont);
    procedure SetCoulFond(Value : TColor);
    procedure SetFTitre(Value : String);
    procedure SetFCadre(Value : TCadreType);
    procedure SetFDecalHor(Value : integer);
    procedure SetFDecalVert(Value : integer);
  public
    constructor create(Aowner : TComponent); override;
    destructor destroy;override;
  published
    property Titre : String  read FTitre  write SetFTitre ;
    property Font  : TFont read FFont write SetFont;
    property CouleurFond : TColor read FCoulFond write SetCoulFond
    default clWhite;
    property Cadre : TCadreType read FCadre write SetFCadre;
    property DecalHor : integer read FDecalhor write SetFDecalHor
    default 2;
    property DecalVert : integer read FDecalVert write SetFDecalVert
    default 2;
  end;
  procedure Register;

Implementation

procedure TFontImage.SetFTitre(Value : String);
Begin
  if Ftitre <> Value then
  begin
    FTitre := Value;
    ReDessine(self);
  end;
End;

procedure TFontImage.SetFont(Value : TFont);
Begin
  if FFont <> Value then
  begin
    FFont.Assign(Value);
  end;
End;

procedure TFontImage.SetCoulFond(Value : TColor);
begin
  if FCoulFond <> Value then
  begin
    FCoulFond := Value;
    ReDessine(self);
  end;
end;

procedure TFontImage.SetFCadre(Value : TCadreType);
Begin
  if FCadre <> Value then
  begin
    FCadre := Value;
    ReDessine(self);
  end;
End;

procedure TFontImage.SetFDecalHor(Value : integer);
Begin
  if FDecalHor <> Value then
  begin
    FDecalHor := Value;
    ReDessine(self);
  end;
End;

procedure TFontImage.SetFDecalVert(Value : integer);
Begin
  if FDecalVert <> Value then
  begin
    FDecalVert := Value;
    ReDessine(self);
  end;
End;

procedure TFontImage.Redessine(Sender: TObject);
var bmp : TBitmap;
begin
 if csLoading in ComponentState then Exit;
 if csDesigning in ComponentState then
  begin
    if (FTitre = '') then Exit;
    bmp := TBitmap.Create;     (* We create a bitmap  *)
    try
      bmp.Width := 1200;  (* Max width  , taille surdimensionne *)
      bmp.Height := 600;  (* Max height *)


      bmp.Canvas.Font := FFont;
      bmp.Canvas.Brush.Color := FCoulFond;

      bmp.Width := bmp.Canvas.TextWidth(FTitre)+FDecalHor*2;
      bmp.Height := bmp.Canvas.TextHeight(FTitre)+FDecalVert*2;

      With bmp.Canvas do
      begin
        FillRect(Rect(0,0,bmp.width,bmp.height));
        Brush.Style := bsClear;
        Case FCadre of
          caNone     : begin
                       (* nothing , pas de cadre *)
                       end;
          caStandard : begin
                         Pen.Color := clBlack;
                         Rectangle(0,0,bmp.Width,bmp.Height);
                       end;
          ca3DRaised : begin
                         Pen.Color := clBlack;
                         Rectangle(0,0,bmp.Width,bmp.Height);
                         Pen.Color := clWhite;
                         MoveTo(0,0);
                         LineTo(bmp.Width,0);
                         MoveTo(0,0);
                         LineTo(0,bmp.Height);
                       end;
         ca3DLowered : begin
                         Pen.Color := clWhite;
                         Rectangle(0,0,bmp.Width,bmp.Height);
                         Pen.Color := clBlack;
                         MoveTo(0,0);
                         LineTo(bmp.Width,0);
                         MoveTo(0,0);
                         LineTo(0,bmp.Height);
                       end;

        end; (* Case *)
        TextOut(FDecalHor,FDecalVert,FTitre);   (*  we  write in the bitmap *)
      end; (* with bmp.Canvas *)

      Picture.Graphic := bmp;
      Width := bmp.Width;     (* We give the FontImage it's real size, taille relle  *)
      Height := bmp.Height;
    finally
      bmp.Free;   (* and free the bitmap *)
    end;
  end;
end;

constructor TFontImage.Create(Aowner : TComponent);
begin
  inherited Create(AOwner);
  FFont := TFont.Create;       (* Font creation *)
  FFont.Name := 'Arial';
  FFont.Size := 20;
  FFont.OnChange:= Redessine;
  FCoulfond := clWhite;
  FDecalHor := 2;
  FDecalVert := 2;
end;

destructor TFontImage.Destroy;
begin
  FFont.Free;              (* Font destruction *)
  inherited Destroy;
end;

(* Registration of our component, enregistrement du composant *)
procedure Register;
begin
  // RegisterComponents('Samples',[TFontImage]);
  RegisterComponents('Exemples',[TFontImage]);
end;

end.



